## ansible molecule tests for role: docker_containers



## Why to use it
It's allways a good idea to test your things.

With **ansible molecule** you can test your role locally without the need of using a **real server** but a local **docker container**.

## Dependencies

- ### molecule
  You need to have [ansible molecule](https://ansible.readthedocs.io/projects/molecule/installation/) installed.

- ### DIND (docker in docker)
    For using the tests, you will to have **docker** installed locally and and set it for using **DIND (docker in docker)**


    - ### DIND linux
      You have to create/edit the file **/etc/docker/daemon.json** with the content:

    ```json
    {
    "exec-opts": ["native.cgroupdriver=systemd"],
    "features": {
        "buildkit": true
    },
    "experimental": true,
    "cgroup-parent": "docker.slice"
    }
    ```


## Configuration
There's not much for configuring for using the tests

## Running the tests
For running the **molecule tests** you just need to run the command:

```bash
molecule test
```
